<?php

namespace JLGR\Views;

use Illuminate\Support\ServiceProvider;
use JLGR\Views\Actions;
use JLGR\Views\Contracts;

class ViewsServiceProvider extends ServiceProvider
{

	/**
	 * Bootstrap services.
	 *
	 * @return void
	 */
	public function boot ()
	{
		// // Publish the package's configuration file.
		$this->publishConfigFile();

		// // Publish the package's migration file.
		$this->publishMigrations();
	}
	
	/**
	 * Register services.
	 *
	 * @return void
	 */
	public function register ()
	{
		// // Merge config file.
		$this->mergeConfigFile();

		// Register action bindings.
		$this->registerActionBindings();
	}

	/**
	 * Register action bindings.
	 * 
	 * @return void
	 */
	protected function registerActionBindings ()
	{
		$this->app->singleton(Contracts\RegistersView::class, Actions\RegisterView::class);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishConfigFile () : void
	{
		$this->publishes([
			__DIR__.'/../config/views.php' => config_path('jlgr/views.php'),
		], 'jlgr-config');
	}

	/**
	 * Merge the package's configuration file.
	 * 
	 * @return void
	 */
	protected function mergeConfigFile () : void
	{
		$this->mergeConfigFrom(
			__DIR__ . '/../config/views.php',
			'jlgr.views'
		);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishMigrations () : void
	{
		$this->publishes([
			__DIR__.'/../database/migrations' => database_path('migrations'),
		], 'jlgr-migrations');
	}

}
