<?php

namespace JLGR\Views\Models;

use Illuminate\Database\Eloquent\Relations\MorphTo;
use JLGR\Kernel\Models\BaseModel;

class ViewStatistic extends BaseModel
{

	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'view_statistics';

	/**
	 * The attributes that are protected from mass assignment.
	 *
	 * @var array<int, string>
	 */
	protected $guarded = [];

	/**
	 * Get the parent viewable model (flight, etc).
	 */
	public function viewable () : MorphTo
	{
		return $this->morphTo();
	}

}
