<?php

namespace JLGR\Views\Models;

use Illuminate\Database\Eloquent\Relations\{ BelongsTo, MorphTo };
use JLGR\Kernel\Models\BaseModel;

class View extends BaseModel
{

	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'views';

	/**
	 * The attributes that are protected from mass assignment.
	 *
	 * @var array<int, string>
	 */
	protected $guarded = [];

	/**
	 * Get the parent viewable model (flight, etc).
	 */
	public function viewable () : MorphTo
	{
		return $this->morphTo();
	}

	/**
	 * Get the user that owns the view.
	 */
	public function user () : BelongsTo
	{
		return $this->belongsTo(config('jlgr.views.user_model'));
	}

}
