<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up ()
    {
        Schema::create('view_statistics', function (Blueprint $table) {
            $table->id();
            $table->morphs('viewable');
            $table->unsignedInteger('count_unique')->default(0);
            $table->unsignedInteger('count_total')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down ()
    {
        Schema::dropIfExists('view_statistics');
    }

};
