<?php

namespace JLGR\UserReports;

use Illuminate\Support\ServiceProvider;
use Livewire\Livewire;

class UserReportsServiceProvider extends ServiceProvider
{

	/**
	 * Bootstrap services.
	 *
	 * @return void
	 */
	public function boot ()
	{
		// Publish the package's configuration file.
		$this->publishConfigFile();

		// Publish the package's migration file.
		$this->publishMigrations();
		
		// Load views.
		$this->loadViewsFrom(__DIR__.'/../resources/views', 'user-reports');

		// Register Livewire components.
		$this->registerLivewireComponents();

		// Register model observers.
		$this->registerObservers();
	}
	
	/**
	 * Register services.
	 *
	 * @return void
	 */
	public function register ()
	{
		// Register action bindings.
		$this->registerActionBindings();

		// Register package repository.
		$this->registerRepository();

		// Merge config file.
		$this->mergeConfigFile();
	}

	/**
	 * Load custom routes.
	 *
	 * @return void
	 */
	protected function registerLivewireComponents ()
	{
		// Admin table component.
		//Livewire::component('jlgr.user-reports.admin-table', \JLGR\UserReports\Livewire\AdminTable::class);

		// Bug report form.
		Livewire::component('jlgr.user-reports.user-report-form', \JLGR\UserReports\Livewire\UserReportForm::class);
	}

	/**
	 * Register action bindings.
	 * 
	 * @return void
	 */
	protected function registerActionBindings ()
	{
		$this->app->singleton(
			\JLGR\UserReports\Contracts\CreatesUserReport::class,
			\JLGR\UserReports\Actions\CreateUserReport::class
		);
	}

	/**
	 * Register the package repository.
	 * 
	 * @return void
	 */
	protected function registerRepository () : void
	{
		$this->app->bind(
			\JLGR\UserReports\Repositories\UserReportRepository::class,
			fn ($app) => new \JLGR\UserReports\Repositories\UserReportRepository
		);
	}

	/**
	 * Register observers.
	 * 
	 * @return void
	 */
	protected function registerObservers () : void
	{
		\JLGR\UserReports\Models\UserReport::observe(\JLGR\UserReports\Observers\UserReportObserver::class);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishConfigFile () : void
	{
		$this->publishes([
			__DIR__.'/../config/user-reports.php' => config_path('jlgr/user-reports.php'),
		], 'jlgr-config');
	}

	/**
	 * Merge the package's configuration file.
	 * 
	 * @return void
	 */
	protected function mergeConfigFile () : void
	{
		$this->mergeConfigFrom(
			__DIR__ . '/../config/user-reports.php',
			'jlgr.user-reports'
		);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishMigrations () : void
	{
		$this->publishes([
			__DIR__.'/../database/migrations' => database_path('migrations'),
		], 'jlgr-migrations');
	}

}
