<?php

namespace JLGR\UserReports\Repositories;

use JLGR\UserReports\Queries\AllUserReports;
use JLGR\UserReports\Enums\Status;
use JLGR\Kernel\Enums\CacheDuration;
use JLGR\Kernel\Repositories\BaseRepository;

class UserReportRepository extends BaseRepository
{

	/**
	 * Constructor.
	 */
	public function __construct ()
	{
		// Indicates whether caching is enabled.
		$this->useCaching = config('jlgr.user-reports.cache.enabled');

		// Get default cache tags.
		$this->cacheTag = config('jlgr.user-reports.cache.tag');
	}

	/**
	 * Get number of new user alerts.
	 * 
	 * @param  array  $params
	 * 
	 * @return int
	 */
	public function getNumberOfNewUserReports (array $params = []) : int
	{
		$params = array_merge($params, [ 'status' => Status::New ]);

		return $this->retrieveFromCache(
			cacheKey: "number-of-new-user-reports",
			callback: fn () => AllUserReports::count($params),
			duration: CacheDuration::OneHour
		);
	}
	
}
