<?php

namespace JLGR\UserReports\Observers;

use Illuminate\Support\Facades\Cache;
use JLGR\UserReports\Models\UserReport;
use JLGR\UserReports\Jobs\SendUserReportedNotification;

class UserReportObserver
{

	/**
	 * Handle the "created" event.
	 * 
	 * @param  \JLGR\UserReports\Models\UserReport  $userAlert
	 */
	public function created (UserReport $userAlert)
	{
		$this->invalidateCache();

		$this->sendAdminNotification($userAlert);
	}

	/**
	 * Handle the "updated" event.
	 * 
	 * @param  \JLGR\UserReports\Models\UserReport  $userAlert
	 */
	public function updated (UserReport $userAlert)
	{
		$this->invalidateCache();
	}

	/**
	 * Handle the "deleted" event.
	 * 
	 * @param  \JLGR\UserReports\Models\UserReport  $userAlert
	 */
	public function deleted (UserReport $userAlert)
	{
		$this->invalidateCache();
	}

	/**
	 * Invalidate cache.
	 * 
	 * @return void
	 */
	private function invalidateCache () : void
	{
		Cache::tags(config('jlgr.user-reports.cache.tag'))->flush();
	}

	/**
	 * Send admin notification.
	 * 
	 * @param  \JLGR\UserReports\Models\UserReport  $userAlert
	 * 
	 * @return void
	 */
	private function sendAdminNotification (UserReport $userAlert) : void
	{
		if (config('jlgr.user-reports.notifications.enabled'))
		{
			SendUserReportedNotification::dispatch($userAlert->id);
		}
	}

}
