<?php

namespace JLGR\UserReports\Models;

use JLGR\Kernel\Models\BaseModel;

class UserReportCategory extends BaseModel
{

	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'user_report_categories';

	/**
	 * The attributes that are protected from mass assignment. An empty
	 * array means all fields are mass assignable.
	 * 
	 * @var array
	 */
	protected $guarded = [];

	/**
	 * Scope a query to get only enabled categories.
	 *
	 * @param  \Illuminate\Database\Eloquent\Builder $query
	 *
	 * @return \Illuminate\Database\Eloquent\Builder
	 */
	public function scopeWhereEnabled ($query)
	{
		return $query->where('enabled', true);
	}

	/**
	 * Scope a query to sort ascending by order.
	 *
	 * @param  \Illuminate\Database\Eloquent\Builder $query
	 *
	 * @return \Illuminate\Database\Eloquent\Builder
	 */
	public function scopeInDefaultOrder ($query)
	{
		return $query->orderBy('order', 'asc');
	}

}
