<?php

namespace JLGR\UserReports\Livewire;

use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Config;
use Livewire\Component;
use JLGR\UserReports\Contracts\CreatesUserReport;
use JLGR\UserReports\Filament\UserReportFormBuilder;

class UserReportForm extends Component implements HasForms
{
	use InteractsWithForms;

	/**
	 * The form's state.
	 * 
	 * @var array
	 */
	public ?array $data = [];

	/**
	 * The user to be reported.
	 * 
	 * @var \App\Models\User
	 */
	public $user = null;

	/**
	 * Flag indicating the visibility of the message sent message.
	 */
	public $messageSent = false;

	/**
	 * Mount the component.
	 * 
	 * @param  Model  $user
	 * 
	 * @return void
	 */
	public function mount (Model $user) : void
	{
		// Retrieve user model from the config settings.
		$userModel = Config::get('jlgr.user-reports.user_model');

		// Ensure $user is instance of the model from the config.
		if (!$user instanceof $userModel) {
			$user = $userModel::findOrFail($user);
		}

		// Get and set user on the instance.
		$this->user = $user;
		
		$this->data['user_id'] = $this->user->id;
	}
	
	/**
	 * Submit the form.
	 * 
	 * @return void
	 */
	public function submitForm (CreatesUserReport $processor) : void
	{
		$this->validate();

		$processor->createUserReport($this->data);

		$this->messageSent = true;

		$this->reset('data');
	}
	
	/**
	 * Form builder.
	 * 
	 * @param  \Filament\Forms\Form $form
	 * 
	 * @return \Filament\Forms\Form
	 */
	public function form (Form $form) : Form { return UserReportFormBuilder::get($form); }

	/**
	 * Render the view.
	 */
	public function render ()
	{
		return view('user-reports::user-report-form.default');
	}

}
