<?php

namespace JLGR\UserReports\Filament;

use Filament\Forms\{ Components, Form, Get};
use JLGR\UserReports\Models\UserReportCategory;

class UserReportFormBuilder
{

	/**
	 * Build edit form.
	 * 
	 * @param  Form  $form
	 * 
	 * @return Form
	 */
	public static function get (Form $form) : Form
	{
		return $form
			->schema([
				Components\Grid::make(12)
					->schema([
						Components\Select::make('category_id')
							->columnSpan(6)
							->label(__('What do you want to report?'))
							->options(UserReportCategory::whereEnabled()->inDefaultOrder()->get()->pluck('name', 'id'))
							->required()
							->live(),
						Components\TextInput::make('url')
							->columnSpanFull()
							->label(__('Url of the (flight) page'))
							->helperText(__('You can copy this from the url bar of your browser'))
							->required()
							->visible(fn (Get $get) => $get('category_id') == 4),
						Components\Textarea::make('description')
							->columnSpanFull()
							->label(__('Why do you want to report this user?'))
							->rows(5)
							->required(),
					])
			])
			->statePath('data');
	}

}
