<?php

namespace JLGR\UserReports\Actions;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use JLGR\UserReports\Contracts\CreatesUserReport;
use JLGR\UserReports\Enums\Status;
use JLGR\UserReports\Models\UserReport;

class CreateUserReport implements CreatesUserReport
{

	/**
	 * Create user alert
	 *
	 * @param  array  $input
	 * 
	 * @return void
	 */
	public function createUserReport (array $input) : void
	{
		// Write user report.
		UserReport::create([
			'reporting_user_id' => Auth::user()->id,
			'reported_user_id' => $input['user_id'],
			'status' => Status::New->value,
			'category_id' => $input['category_id'],
			'description' => Str::trim($input['description']),
			'url' => $input['url'] ?? null,
		]);
	}

}
