@props([
	'country' => null,
	'size' => 'h-6',
	'shape' => 'circular',
])


@php

	// Base classes.
	$baseClasses = 'inline-block';
	$sizeClasses = $size;

	// Merged classes.
	$mergedClasses = implode(' ', [ $baseClasses, $sizeClasses ]);

	// Image url.
	$imageUrl = 'https://aes.ams3.cdn.digitaloceanspaces.com/assets/flags/' . $shape . '/' . $country?->isocode . '.svg';

@endphp


@if ($country)
	<img class="{{ $mergedClasses }}" src="{{ $imageUrl }}" alt="{{ $country->name }}" />
@else
	<span class="{{ $mergedClasses }}" role="img" aria-label="{{ __('Unknown country') }}">
		<span class="text-gray-400">❓</span>
	</span>
@endif
