<?php

return [

	/*
	|--------------------------------------------------------------------------
	| User Model
	|--------------------------------------------------------------------------
	|
	| Define the user model used to associate comments.
	|
	*/

	'user_model' => \App\Models\User::class,


	/**
	 * Routes for redirecting after submitting the form.
	 */
	'routes' => [

		// Single user.
		'user' => [

			// Route name. If set to null, the redirect button will not be rendered.
			'route-name' => null,

			// Route parameter. For example: '.../users/{user}/profile'.
			'route-parameter' => 'user',

			// Button label.
			'button-label' => 'Back to user profile',
		],

		// All users.
		'users' => [

			// Route name. If set to null, the redirect button will not be rendered.
			'route-name' => null,

			// Button label.
			'button-label' => 'Show all users'
		],
	],

	/**
	 * Caching.
	 */
	'cache' => [

		// Indicates whether caching is enabled.
		'enabled' => env('CACHING_ENABLED', true),

		// Default cache tags.
		'tag' => 'user-reports',

	],

	/**
	 * Notifications.
	 */
	'notifications' => [

		// Indicates whether sending notificartions is enabled.
		'enabled' => true,

		// Admin e-mail for receiving notifications.
		'admin_email' => 'admin@example.com',

		// Default queue for dispatching the notification to.
		'queue' => 'default',

	],

	/**
	 * Classes.
	 */
	'user_model' => \App\Models\User::class,

	/**
	 * Styling.
	 */
	'css' => [

		// Form id selector.
		'form-selector' => 'data-form',

		// Table id selector.
		'table-selector' => 'data-table',
	],
	
];