<?php

namespace JLGR\UserReports\Models;

use JLGR\Kernel\Models\BaseModel;

class UserReport extends BaseModel
{

	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'user_reports';

	/**
	 * The attributes that are protected from mass assignment. An empty
	 * array means all fields are mass assignable.
	 * 
	 * @var array
	 */
	protected $guarded = [];

	/**
	 * The reported user.
	 */
	public function reportedUser ()
	{
		return $this->belongsTo(config('jlgr.user-reports.user_model'), 'reported_user_id');
	}

	/**
	 * The reporting user.
	 */
	public function reportingUser ()
	{
		return $this->belongsTo(config('jlgr.user-reports.user_model'), 'reporting_user_id');
	}

	/**
	 * The category this report belongs to.
	 */
	public function category ()
	{
		return $this->belongsTo(UserReportCategory::class, 'category_id');
	}

}
