<?php

namespace JLGR\UserReports\Livewire;

use Filament\Actions\Contracts\HasActions;
use Filament\Actions\Concerns\InteractsWithActions;
use Filament\Schemas\Schema;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Config;
use Livewire\Component;
use JLGR\UserReports\Contracts\CreatesUserReport;
use JLGR\UserReports\Filament\UserReportFormBuilder;

class UserReportForm extends Component implements HasForms, HasActions
{
	use InteractsWithActions;
    use InteractsWithForms;

	/**
	 * The form's state.
	 * 
	 * @var array
	 */
	public ?array $data = [];

	/**
	 * The user to be reported.
	 * 
	 * @var \App\Models\User
	 */
	public $user = null;

	/**
	 * Flag indicating the visibility of the message sent message.
	 */
	public $messageSent = false;

	/**
	 * Mount the component.
	 * 
	 * @param  Model  $user
	 * 
	 * @return void
	 */
	public function mount (Model $user) : void
	{
		// Retrieve user model from the config settings.
		$userModel = Config::get('jlgr.user-reports.user_model');

		// Ensure $user is instance of the model from the config.
		if (!$user instanceof $userModel) {
			$user = $userModel::findOrFail($user);
		}

		// Get and set user on the instance.
		$this->user = $user;
		
		$this->data['user_id'] = $this->user->id;
	}
	
	/**
	 * Submit the form.
	 * 
	 * @return void
	 */
	public function submitForm (CreatesUserReport $processor) : void
	{
		$this->validate();

		$processor->createUserReport($this->data);

		$this->messageSent = true;

		$this->reset('data');
	}
	
	/**
     * Form builder.
     *
     * @param Schema $schema
     *
     * @return Schema
     */
    public function form (Schema $schema) : Schema { return UserReportFormBuilder::get($schema); }

	/**
	 * Render the view.
	 */
	public function render ()
	{
		return view('user-reports::user-report-form.default');
	}

}
