<?php

namespace JLGR\UserReports\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendUserReportedNotification implements ShouldQueue
{
	use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

	/**
	 * User report id.
	 * 
	 * @var integer
	 */
	protected $userReportId;

	/**
	 * Create a new job instance.
	 * 
	 * @param  integer  $userId
	 * 
	 * @return void
	 */
	public function __construct ($userReportId)
	{
		$this->userReportId = $userReportId;

		$this->onQueue(config('jlgr.user-reports.notifications.queue'));
	}

	/**
	 * Execute the job.
	 * Will be processed on the worker server.
	 * 
	 * @return void
	 */
	public function handle () : void {}

}
