<?php

namespace JLGR\UserReports\Filament;

use Filament\Schemas\Schema;
use Filament\Schemas\Components\Grid;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\{ Components, Form, Get};
use JLGR\UserReports\Models\UserReportCategory;

class UserReportFormBuilder
{

	/**
     * Build edit form.
     *
     * @param Schema $schema
     *
     * @return Schema
     */
    public static function get (Schema $schema) : Schema
	{
		return $schema
			->components([
				Grid::make(12)
					->schema([
						Select::make('category_id')
							->columnSpan(6)
							->label(__('What do you want to report?'))
							->options(UserReportCategory::whereEnabled()->inDefaultOrder()->get()->pluck('name', 'id'))
							->required()
							->live(),
						TextInput::make('url')
							->columnSpanFull()
							->label(__('Url of the (flight) page'))
							->helperText(__('You can copy this from the url bar of your browser'))
							->required()
							->visible(fn (\Filament\Schemas\Components\Utilities\Get $get) => $get('category_id') == 4),
						Textarea::make('description')
							->columnSpanFull()
							->label(__('Why do you want to report this user?'))
							->rows(5)
							->required(),
					])
			])
			->statePath('data');
	}

}
