<?php

namespace JLGR\UserReports\Enums;

enum Status : string
{

	// Cases...
	case New      	= 'new';
	case Pending    = 'pending';
	case Ignored    = 'ignored';
	case Completed  = 'completed';

	/**
	 * Get the corresponding label.
	 *
	 * @return string
	 */
	public function getLabel () : string
	{
		return match ($this) {
			self::New 		=> __('New'),
			self::Pending	=> __('Pending'),
			self::Ignored	=> __('Ignored'),
			self::Completed	=> __('Completed'),
		};
	}

}
