<?php

namespace JLGR\UserReports\Concerns;

use Illuminate\Support\Facades\Session;

trait CanReportUser
{

    /**
     * Redirect to the report user page.
     * 
     * @param  integer  $userId  User to be reported.
     */
    public function reportUser ($userId)
    {
        // Store the user id in the authenticated user's session.
        Session::put('reportingUserId', $userId);

        // Redirect to the page with the reporting form.
        $reportUserForm = config('reporting-users.report-form');

        // Redirect to the reporting form.
        return redirect($reportUserForm);
    }

}
