<form id="{{ config('jlgr.user-reports.css.form-selector') }}" wire:submit="submitForm">

	@if ($user == null)

		<p class="font-bold text-red-700">
			{{ __('Sorry, but we cannot load the information of the user you want to report.') }}
		</p>

	@else
		@if ($messageSent == true)

			<div class="mb-4">
				<p class="font-bold text-green-700">
					{{ __('Thanks, we have received your message.') }}
				</p>
				<div class="gap-2 mt-4">
					@if ($routeName = config('jlgr.user-reports.routes.user.route-name'))
						<x-filament::button tag="a" :href="route(config('jlgr.user-reports.routes.user.route-name'), [ config('jlgr.user-reports.routes.user.route-parameter') => $user->id ])">
							{{ __(config('jlgr.user-reports.routes.user.button-label')) }}
						</x-filament::button>
					@endif
					@if ($routeName = config('jlgr.user-reports.routes.users.route-name'))
						<x-filament::button tag="a" :href="route(config('jlgr.user-reports.routes.users.route-name'))">
							{{ __(config('jlgr.user-reports.routes.users.button-label')) }}
						</x-filament::button>
					@endif
				</div>
			</div>
		
		@else
			
			{{-- MEMBER INFORMATION --}}
			<div class="">
				<x-heading.h3>
					{{ $user->name }}
				</x-heading.h3>
				<div class="flex items-center">
					<x-jlgr::image.flag :country="$user->homeAirport->country" />
					<span class="font-bold ml-1.5">
						{{ $user->homeAirport->icao }}
					</span>
					<span class="text-sm mx-2">&bullet;</span>
					<span>
						{{ $user->homeAirport->name }}
					</span>
				</div>
			</div>

			<div class="mt-6">
				{{ $this->form }}
			</div>
					
			<div class="mt-6">
				<x-filament::button type="submit">
					{{ __('Report user') }}
				</x-filament::button>
			</div>

		@endif
	@endif

</form>
