<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use JLGR\UserReports\Enums\Status;

return new class extends Migration
{

    /**
     * Run the migrations.
     */
    public function up () : void
    {
        Schema::create('user_reports', function (Blueprint $table) {
            $table->id();
			$table->foreignId('reported_user_id')->constrained('users');
			$table->foreignId('reporting_user_id')->constrained('users');
            $table->enum('status', [
                Status::New->value,
                Status::Pending->value,
                Status::Ignored->value,
                Status::Completed->value,
            ])->default(Status::New->value);
			$table->foreignId('category_id')->constrained('user_report_categories');
            $table->text('description');
            $table->string('url')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down () : void
    {
        Schema::dropIfExists('user_reports');
    }

};
