<?php

namespace JLGR\SystemMessages;

use Illuminate\Support\ServiceProvider;
use Livewire\Livewire;

class SystemMessagesServiceProvider extends ServiceProvider
{

	/**
	 * Bootstrap services.
	 *
	 * @return void
	 */
	public function boot ()
	{
		// Publish the package's configuration file.
		$this->publishConfigFile();

		// Publish the package's migration file.
		$this->publishMigrations();
		
		// Load views.
		$this->loadViewsFrom(__DIR__.'/../resources/views', 'system-messages');

		// Register Livewire components.
		$this->registerLivewireComponents();

		// Register model observers.
		$this->registerObservers();

		// Merge config file.
		$this->mergeConfigFile();
	}
	
	/**
	 * Register services.
	 *
	 * @return void
	 */
	public function register ()
	{
		// Register action bindings.
		$this->registerActionBindings();

		// Register package repository.
		$this->registerRepository();
	}

	/**
	 * Load custom routes.
	 *
	 * @return void
	 */
	protected function registerLivewireComponents ()
	{
		// Admin table component.
		Livewire::component('jlgr.system-messages.message', \JLGR\SystemMessages\Livewire\Message::class);
		Livewire::component('jlgr.system-messages.message-container', \JLGR\SystemMessages\Livewire\MessageContainer::class);

		// Admin table component.
		// ...
	}

	/**
	 * Register action bindings.
	 * 
	 * @return void
	 */
	protected function registerActionBindings ()
	{
		// $this->app->singleton(
		// 	\JLGR\SystemMessages\Contracts\CreatesSystemMessage::class,
		// 	\JLGR\SystemMessages\Actions\CreateSystemMessage::class
		// );
	}

	/**
	 * Register the bug report repository.
	 * 
	 * @return void
	 */
	protected function registerRepository () : void
	{
		$this->app->bind(
			\JLGR\SystemMessages\Repositories\SystemMessageRepository::class,
			fn ($app) => new \JLGR\SystemMessages\Repositories\SystemMessageRepository
		);
	}

	/**
	 * Register observers.
	 * 
	 * @return void
	 */
	protected function registerObservers () : void
	{
		\JLGR\SystemMessages\Models\SystemMessage::observe(\JLGR\SystemMessages\Observers\SystemMessageObserver::class);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishConfigFile () : void
	{
		$this->publishes([
			__DIR__.'/../config/system-messages.php' => config_path('jlgr/system-messages.php'),
		], 'jlgr-config');
	}

	/**
	 * Merge the package's configuration file.
	 * 
	 * @return void
	 */
	protected function mergeConfigFile () : void
	{
		$this->mergeConfigFrom(
			__DIR__ . '/../config/system-messages.php',
			'jlgr.system-messages'
		);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishMigrations () : void
	{
		$this->publishes([
			__DIR__.'/../database/migrations' => database_path('migrations'),
		], 'jlgr-migrations');
	}

}
