<?php

namespace JLGR\SystemMessages\Queries;

use Illuminate\Database\Eloquent\Builder;
use JLGR\Kernel\Queries\Eloquent\BaseQuery;
use JLGR\SystemMessages\Models\SystemMessage;

class AllSystemMessages extends BaseQuery
{

	/**
	 * Get all published system messages.
	 * 
	 * @param array $attributes
	 * 
	 * @return \Illuminate\Database\Eloquent\Collection
	 */
	protected static function builder (array $attributes = []) : Builder
	{
		return static::newQuery(new SystemMessage)

			// Filter on published messages.
			->wherePublished()

			// Filter on mnessages that should be visible according to the
			// start and end publishing dates.
			->shouldBeVisible();
	}

}
