<?php

namespace JLGR\SystemMessages\Observers;

use Illuminate\Support\Facades\Cache;
use JLGR\SystemMessages\Models\SystemMessage;

class SystemMessageObserver
{

	/**
	 * Handle the "created" event.
	 * 
	 * @param  \App\Packages\SystemMessages\Models\SystemMessage  $systemMessage
	 */
	public function created (SystemMessage $systemMessage)
	{
		$this->invalidateCache();
	}

	/**
	 * Handle the "updated" event.
	 * 
	 * @param  \App\Packages\SystemMessages\Models\SystemMessage  $systemMessage
	 */
	public function updated (SystemMessage $systemMessage)
	{
		$this->invalidateCache();
	}

	/**
	 * Handle the "deleted" event.
	 * 
	 * @param  \App\Packages\SystemMessages\Models\SystemMessage  $systemMessage
	 */
	public function deleted (SystemMessage $systemMessage)
	{
		$this->invalidateCache();
	}

	/**
	 * Invalidate cache.
	 * 
	 * @return void
	 */
	private function invalidateCache () : void
	{
		Cache::tags(config('jlgr.system-messages.cache.tag'))->flush();
	}

}
