<?php

namespace JLGR\SystemMessages\Livewire;

use JLGR\SystemMessages\Queries\AllMessages;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use JLGR\SystemMessages\Repositories\SystemMessageRepository;

class MessageContainer extends Component
{

	/**
	 * Message collection 
	 * 
	 * @var \Illuminate\Database\Eloquent\Collection
	 */
	public $messages = [];

	/**
	 * Mount the component.
	 * 
	 * @param  SystemMessageRepository  $repository
	 */
	public function mount (SystemMessageRepository $repository)
	{
		$this->messages = $repository->getSystemMessages();
	}

	/**
	 * Render the view.
	 */
	public function render ()
	{
		return view('system-messages::message-container.default');
	}

}
