<?php

namespace JLGR\SystemMessages\Livewire\Admin;

use JLGR\SystemMessages\Contracts\UpdatesSystemMessage;
use JLGR\SystemMessages\Filament\SystemMessageForm;
use JLGR\SystemMessages\Models\SystemMessage;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Illuminate\Support\Facades\Redirect;
use Livewire\Attributes\Layout;
use Livewire\Component;

class EditSystemMessage extends Component implements HasForms
{
    use InteractsWithForms;

	/**
	 * Current admin.
	 * 
	 * @var SystemMessage $systemMessage
	 */
	public $systemMessage;

	/**
	 * The form's state.
	 * 
	 * @var array
	 */
	public ?array $data = [];

	/**
	 * Mount component.
	 * 
	 * @param  SystemMessage  $admin
	 */
	public function mount (SystemMessage $systemMessage)
	{
		$this->systemMessage = $systemMessage;

		// Hydrate form and set acl data.
		$this->form->fill($systemMessage->toArray());
	}

	/**
	 * Form builder.
	 * 
	 * @param  Form  $form
	 * 
	 * @return Form
	 */
	public function form (Form $form) : Form { return SystemMessageForm::get($form); }

	/**
	 * Process form.
	 * 
	 * @param  UpdatesSystemMessage  $processor
	 * 
	 * @return Redirect
	 */
	public function processForm (UpdatesSystemMessage $processor)
	{
		$this->validate();

		$processor->updateSystemMessage($this->systemMessage, $this->data);

		return Redirect::route('system-messages');
	}

	/**
	 * Render the view.
	 */
	#[ Layout('layouts.app.index') ]
	public function render ()
	{
		return view('packages.system-messages.admin.edit-system-message.default');
	}

}
