<?php

namespace JLGR\SystemMessages\Filament;

use JLGR\SystemMessages\Enums\Status;
use Filament\Forms\{ Components, Form };

class SystemMessageFormBuilder
{

	/**
	 * Build form.
	 * 
	 * @param  Form  $form
	 * @param  boolean  $withSubject
	 * 
	 * @return Form
	 */
	public static function get (Form $form) : Form
	{
		return $form
			->schema([
				Components\Select::make('status')
					->columnSpan(4)
					->label(__('Status'))
					->required()
					->options([
						Status::Draft->value,
						Status::Published->value,
						Status::Unpublished->value,
					]),
				Components\TextInput::make('title')
					->columnSpanFull()
					->label(__('Title'))
					->required(),
				Components\TextArea::make('text')
					->columnSpanFull()
					->label(__('Message text'))
					->required()
					->rows(4),
				Components\TextInput::make('icon')
					->columnSpan(4)
					->label(__('Icon')),
			])
			->statePath('data');
	}

}
