<?php

namespace JLGR\SystemMessages\Repositories;

use Illuminate\Database\Eloquent\Collection;
use JLGR\Kernel\Enums\CacheDuration;
use JLGR\Kernel\Repositories\BaseRepository;
use JLGR\SystemMessages\Enums\Status;
use JLGR\SystemMessages\Queries\AllSystemMessages;

class SystemMessageRepository extends BaseRepository
{

	/**
	 * Constructor.
	 */
	public function __construct ()
	{
		// Indicates whether caching is enabled.
		$this->useCaching = config('jlgr.system-messages.cache.enabled');

		// Get default cache tags.
		$this->cacheTag = config('jlgr.system-messages.cache.tag');
	}

	/**
     * Get all system messages.
     *
     * @param  array  $params
     *
     * @return Collection
     */
    public function getSystemMessages (array $params = []) : Collection
	{
		$params = array_merge($params, [ 'status' => Status::Published ]);

		return $this->retrieveFromCache(
			cacheKey: "number-of-new-system-messages",
			callback: fn () => AllSystemMessages::collection($params),
			duration: CacheDuration::OneHour
		);
	}
	
}
