<?php

namespace JLGR\SystemMessages\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Carbon;
use JLGR\Kernel\Models\BaseModel;

class SystemMessage extends BaseModel
{

	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'system_messages';

	/**
	 * The attributes that are protected from mass assignment. An empty
	 * array means all fields are mass assignable.
	 * 
	 * @var array
	 */
	protected $guarded = [];

	/**
	 * The attributes that should be cast.
	 *
	 * @var array
	 */
	protected $casts = [
		'visible_from' => 'datetime',
		'visible_until' => 'datetime',
	];

	/**
     * Useful local query scopes.
     *
     * @param Builder $query
     *
     * @return Builder
     */
    public function scopeWherePublished ($query) { return $query->where('status', 'published'); }

	/**
     * Scope on messages that should be visible according to the start and
     * and end publishing dates.
     *
     * @param Builder $query
     *
     * @return Builder
     */
    public function scopeShouldBeVisible ($query)
	{
		$now = Carbon::now()->toDateTimeString();

        return $query
			->where(fn ($query)
				=> $query
					->whereNull('visible_from')
              		->orWhere('visible_from', '<=', $now))
			->where(fn ($query)
				=> $query
					->whereNull('visible_until')
					->orWhere('visible_until', '>=', $now));
	}

	/**
	 * Check if the message has an icon set.
	 * 
	 * @return boolean
	 */
	public function hasIcon () : bool
	{
		return !! $this->icon;
	}

}
