<?php

namespace JLGR\SystemMessages\Filament;

use Filament\Schemas\Schema;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\TextArea;
use JLGR\SystemMessages\Enums\Status;
use Filament\Forms\{ Components, Form };

class SystemMessageFormBuilder
{

	/**
     * Build form.
     *
     * @param Schema $schema
     * @param  boolean  $withSubject
     *
     * @return Schema
     */
    public static function get (Schema $schema) : Schema
	{
		return $schema
			->components([
				Select::make('status')
					->columnSpan(4)
					->label(__('Status'))
					->required()
					->options([
						Status::Draft->value,
						Status::Published->value,
						Status::Unpublished->value,
					]),
				TextInput::make('title')
					->columnSpanFull()
					->label(__('Title'))
					->required(),
				TextArea::make('text')
					->columnSpanFull()
					->label(__('Message text'))
					->required()
					->rows(4),
				TextInput::make('icon')
					->columnSpan(4)
					->label(__('Icon')),
			])
			->statePath('data');
	}

}
