<?php

namespace JLGR\SystemMessages\Enums;

enum Status : string
{

	// Cases...
	case Draft      	= 'draft';
	case Published      = 'published';
	case Unpublished    = 'unpublished';

	/**
	 * Get the corresponding label.
	 *
	 * @return string
	 */
	public function getLabel () : string
	{
		return match ($this) {
			self::Draft 		=> __('Draft'),
			self::Published		=> __('Published'),
			self::Unpublished	=> __('Unpublished'),
		};
	}

}
