<?php

namespace JLGR\SystemMessages\Enums;

enum MessageType : string
{

	// Cases...
	case Info      	= 'Info';
	case Warning    = 'Warning';
	case Danger     = 'Danger';
	case Success    = 'Success';

	/**
	 * Get the corresponding icon.
	 *
	 * @return string
	 */
	public function getIcon () : string
	{
		return match ($this) {
			self::Info 		=> '',
			self::Warning	=> '',
			self::Danger	=> '',
			self::Success	=> '',
		};
	}

}