<?php

use JLGR\SystemMessages\Enums\Status;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up ()
	{
		Schema::create('system_messages', function (Blueprint $table) {
			$table->id();
			$table->enum('status', [
				Status::Draft->value,
				Status::Published->value,
				Status::Unpublished->value,
			])->default(Status::Draft->value);
			$table->string('icon')->nullable();
			$table->string('title');
			$table->text('text')->nullable();
			$table->timestamp('visible_from')->nullable();
			$table->timestamp('visible_until')->nullable();
			$table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down ()
	{
		Schema::dropIfExists('system_messages');
	}

};
