<?php

use JLGR\Settings\Services\Settings;
use JLGR\Settings\Enums\Environment;

/**
 * Pluck admin settings from the settings table.
 */
if ( ! function_exists('adminSetting'))
{
	function adminSetting (string $key, $default = null)
	{
		return app(Settings::class)->get($key, $default, Environment::Admin);
	}
}

/**
 * Pluck member settings from the settings table.
 */
if ( ! function_exists('memberSetting'))
{
	function memberSetting (string $key, $default = null)
	{
		return app(Settings::class)->get($key, $default, Environment::Member);
	}
}

/**
 * Pluck global settings from the settings table.
 */
if ( ! function_exists('globalSetting'))
{
	function globalSetting (string $key, $default = null)
	{
		return app(Settings::class)->get($key, $default, Environment::Global);
	}
}
