<?php

namespace JLGR\Settings;

use Illuminate\Support\ServiceProvider;
use JLGR\Settings\Services\Settings;

class SettingsServiceProvider extends ServiceProvider
{

	/**
	 * Bootstrap services.
	 *
	 * @return void
	 */
	public function boot ()
	{
		// Publish the package's migration file.
		$this->publishMigrations();
		
		// Load helper file.
		require_once __DIR__ . '/helpers.php';
	}
	
	/**
	 * Register services.
	 *
	 * @return void
	 */
	public function register ()
	{
		// Register the Settings service class in the app's service container.
		$this->app->singleton(Settings::class, fn ($app) => new Settings());
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishMigrations () : void
	{
		$this->publishes([
			__DIR__ . '/../database/migrations' => database_path('migrations'),
		], 'jlgr-migrations');
	}

}
