<?php

namespace JLGR\Settings\Services;

use JLGR\Settings\Enums\Environment;
use JLGR\Settings\Models\Setting;

class Settings
{

	/**
	 * Get setting.
	 * 
	 * @param  string  $key
	 * @param  mixed  $default
	 * @param  Environment  $environment
	 * 
	 * @return mixed
	 */
	public static function get (string $key, $default = null, $environment = Environment::Global)
	{
		return Setting::query()
			->where('environment', $environment->value)
			->where('key', $key)
			->value('value') ?? $default;
	}

	/**
	 * Set setting.
	 * 
	 * @param  string  $key
	 * @param  mixed  $value
	 * @param  Environment  $environment
	 * 
	 * @return void
	 */
	public static function set (string $key, $value, $environment = Environment::Global) : void
	{
		Setting::updateOrCreate(
			[
				'environment' => $environment->value,
				'key' => $key
			],
			[
				'value' => $value,
			]
		);
	}
	
}
