<?php

namespace JLGR\Settings\Enums;

enum Environment : string
{

	// Cases...
	case Admin     = 'admin';
	case Cache     = 'cache';
	case Global    = 'global';
	case Member    = 'member';
	case Worker    = 'worker';

	/**
	 * Get the corresponding label.
	 *
	 * @return string
	 */
	public function getLabel () : string
	{
		return match ($this) {
			self::Admin		=> __('Admin'),
			self::Cache 	=> __('Cache'),
			self::Global	=> __('Global'),
			self::Member	=> __('Member'),
			self::Worker	=> __('Worker'),
		};
	}
	
}
