<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use JLGR\Settings\Enums\Environment;

return new class extends Migration
{

	/**
	 * Run the migrations.
	 */
	public function up () : void
	{
		Schema::create('settings', function (Blueprint $table) {
			$table->id();
			$table->enum('environment', [
				Environment::Global->value,
				Environment::Admin->value,
				Environment::Member->value,
				Environment::Cache->value,
				Environment::Worker->value,
			])->default(Environment::Global->value);
			$table->string('key');
			$table->text('value')->nullable();
			$table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 */
	public function down () : void
	{
		Schema::dropIfExists('settings');
	}

};
