<?php

namespace JLGR\Reviews;

use JLGR\Reviews\Contracts\CreatesReview;
use JLGR\Reviews\Actions\CreateReview;
use JLGR\Reviews\Contracts\ReportsReview;
use JLGR\Reviews\Actions\ReportReview;
use Illuminate\Support\ServiceProvider;
use JLGR\Reviews\Actions;
use JLGR\Reviews\Contracts;
use JLGR\Reviews\Livewire as LivewireComponents;
use Livewire\Livewire;

class ReviewsServiceProvider extends ServiceProvider
{

	/**
	 * Bootstrap services.
	 *
	 * @return void
	 */
	public function boot ()
	{
		// // Publish the package's configuration file.
		$this->publishConfigFile();

		// // Publish the package's migration file.
		$this->publishMigrations();
		
		// // Load views.
		$this->loadViewsFrom(__DIR__ . '/../resources/views', 'reviews');

		// // Register Livewire components.
		$this->registerLivewireComponents();
	}
	
	/**
	 * Register services.
	 *
	 * @return void
	 */
	public function register ()
	{
		// // Register package repository.
		// $this->registerRepository();

		// // Merge config file.
		$this->mergeConfigFile();

		// Register action bindings.
		$this->registerActionBindings();
	}

	/**
	 * Register action bindings.
	 * 
	 * @return void
	 */
	protected function registerActionBindings ()
	{
		$this->app->singleton(CreatesReview::class, CreateReview::class);
		$this->app->singleton(ReportsReview::class, ReportReview::class);
	}

	/**
	 * Load custom routes.
	 *
	 * @return void
	 */
	protected function registerLivewireComponents ()
	{
		Livewire::component('reviews::review-form', LivewireComponents\ReviewForm::class);
		Livewire::component('reviews::reviews-list', LivewireComponents\ReviewsList::class);
		Livewire::component('reviews::latest-review', LivewireComponents\LatestReview::class);
	}

	/**
	 * Register the bug report repository.
	 * 
	 * @return void
	 */
	protected function registerRepository () : void
	{
		// $this->app->bind(
		// 	\JLGR\ReleaseNotes\Repositories\ReleaseNoteRepository::class,
		// 	fn ($app) => new \JLGR\ReleaseNotes\Repositories\ReleaseNoteRepository
		// );
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishConfigFile () : void
	{
		$this->publishes([
			__DIR__.'/../config/reviews.php' => config_path('jlgr/reviews.php'),
		], 'jlgr-config');
	}

	/**
	 * Merge the package's configuration file.
	 * 
	 * @return void
	 */
	protected function mergeConfigFile () : void
	{
		$this->mergeConfigFrom(
			__DIR__ . '/../config/reviews.php',
			'jlgr.reviews'
		);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishMigrations () : void
	{
		$this->publishes([
			__DIR__.'/../database/migrations' => database_path('migrations'),
		], 'jlgr-migrations');
	}

}
