<?php

namespace JLGR\Reviews\Models;

use Illuminate\Database\Eloquent\Relations\MorphTo;
use JLGR\Kernel\Models\BaseModel;

class ReviewStatistic extends BaseModel
{

	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'review_statistics';

	/**
	 * The attributes that are protected from mass assignment.
	 *
	 * @var array<int, string>
	 */
	protected $guarded = [];

	/**
	 * Get the parent reviewable model (museum, etc).
	 */
	public function reviewable () : MorphTo
	{
		return $this->morphTo();
	}

}
