<?php

namespace JLGR\Reviews\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ReviewReport extends Model
{

	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'review_reports';

	/**
	 * The attributes that are protected from mass assignment.
	 *
	 * @var array<int, string>
	 */
	protected $guarded = [];

	/**
	 * Boot the model.
	 */
	protected static function booted () : void
	{
		static::created(function (ReviewReport $report) : void {
			$review = $report->review;

			if (! $review->manually_approved && $review->reportCount() >= 3) {
				$review->update([ 'approved_at' => null ]);
			}
		});
	}

	/**
	 * Get the review that was reported.
	 */
	public function review () : BelongsTo
	{
		return $this->belongsTo(Review::class);
	}

	/**
	 * Get the user who submitted the report.
	 */
	public function user () : BelongsTo
	{
		return $this->belongsTo(config('jlgr.reviews.user_model'));
	}

}
