<?php

namespace JLGR\Reviews\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use JLGR\Kernel\Models\BaseModel;

class ReviewRating extends BaseModel
{

	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'review_ratings';

	/**
	 * The attributes that are protected from mass assignment.
	 *
	 * @var array<int, string>
	 */
	protected $guarded = [];

    /**
     * Get the review this rating belongs to.
     */
    public function review () : BelongsTo
    {
        return $this->belongsTo(Review::class);
    }

    /**
     * Get the indicator this rating refers to.
     */
    public function indicator () : BelongsTo
    {
        return $this->belongsTo(ReviewIndicator::class, 'review_indicator_id');
    }

}
