<?php

namespace JLGR\Reviews\Models;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use JLGR\Kernel\Models\BaseModel;

class ReviewIndicator extends BaseModel
{

	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'review_indicators';

	/**
	 * The attributes that are protected from mass assignment.
	 *
	 * @var array<int, string>
	 */
	protected $guarded = [];

	/**
	 * Get the ratings associated with this indicator.
	 */
	public function ratings () : HasMany
	{
		return $this->hasMany(ReviewRating::class);
	}

}
