<?php

namespace JLGR\Reviews\Livewire;

use Filament\Actions\Contracts\HasActions;
use Filament\Actions\Concerns\InteractsWithActions;
use Filament\Schemas\Schema;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use IbrahimBougaoua\FilamentRatingStar\Forms\Components\RatingStar;
use JLGR\Reviews\Contracts\CreatesReview;
use JLGR\Reviews\Contracts\Reviewable;
use Livewire\Component;

class ReviewForm extends Component implements HasForms, HasActions
{
	use InteractsWithActions;
    use InteractsWithForms;

	/**
	 * The reviewable model.
	 * 
	 * @var mixed
	 */
	public mixed $reviewable;

	/**
	 * The form's state.
	 * 
	 * @var array
	 */
	public ?array $data = [];

	/**
	 * Component properties.
	 * 
	 * @var mixed
	 */
	public string $template = 'default';

	/**
	 * Mount the component with the reviewable model.
	 * 
	 * @param  mixed  $reviewable
	 */
	public function mount (mixed $reviewable) : void
	{
		$this->reviewable = $reviewable;
	}
	
	/**
     * Build the form.
     *
     * @param \Filament\Forms\Form
     *
     * @return Schema
     */
    public function form (Schema $schema) : Schema
	{
		$indicatorFields = [];
		
		if ($this->reviewable instanceof Reviewable) {
			foreach ($this->reviewable->reviewIndicators() as $indicator) {
				$indicatorFields[] = RatingStar::make("ratings.{$indicator->key}")
					->label($indicator->label)
					->helperText($indicator->description);
			}
		}

		return $schema
			->components([
				...$indicatorFields,
				Textarea::make('text')
					->label(__('Your review'))
					->required()
					->maxLength(1000)
					->rows(5)
					->placeholder(__('Write something nice and useful...'))
					->columnSpanFull(),
			])
			->statePath('data');
	}

	/**
	 * Submit the form and create the review.
	 * 
	 * @param  CreatesReview  $reviewProcessor
	 * 
	 * @return void
	 */
	public function processForm (CreatesReview $reviewProcessor) : void
	{
		$this->validate();

		$reviewProcessor->handle($this->reviewable, $this->data);

		$this->reset('data');
		$this->form->fill(); 	// Clear fields.

		$this->dispatch('review-created');
	}

	/**
	 * Render the component.
	 */
	public function render ()
	{
		return view("reviews::livewire.review-form.{$this->template}");
	}

}
