<?php

namespace JLGR\Reviews\Filament\Columns;

use Filament\Tables\Columns\Column;

class ReviewRatingColumn extends Column
{

	/**
	 * View path.
	 * 
	 * @var string
	 */
	protected string $view = 'reviews::filament.columns.review-rating-column';

	/**
	 * Flag indicating the rating label should be included.
	 * 
	 * @var boolean
	 */
	protected bool $showRating = false;

	/**
	 * Number of decimals for the rating.
	 * 
	 * @var integer
	 */
	protected int $decimals = 2;

	/**
	 * Construct component.
	 * 
	 * @return void
	 */
	protected function setUp () : void
	{
		parent::setUp();

		$this->label('Rating');
	}

	/**
	 * Number of decimals.
	 * 
	 * @param  integer  $decimals
	 * 
	 * @return static
	 */
	public function decimals (int $decimals = 2) : static
	{
		$this->decimals = $decimals;

		return $this;
	}

	/**
	 * Show rating label.
	 * 
	 * @return static
	 */
	public function showRating () : static
	{
		$this->showRating = true;

		return $this;
	}

	/**
	 * Make data available to the view.
	 * 
	 * @return array
	 */
	public function getViewData () : array
	{
		return array_merge(parent::getViewData(), [
			'showRating' => $this->showRating,
			'decimals' => $this->decimals,
		]);
	}

}
