<?php

namespace JLGR\Reviews\Enums;

enum ReviewStatus : string
{

	// Cases...
	case Pending 			= 'pending';
	case Rejected 			= 'rejected';
	case Approved			= 'approved';
	case ViolatesPolicy		= 'violates-policy';

	/**
	 * Get the corresponding label.
	 *
	 * @return string
	 */
	public function getLabel () : string
	{
		return match ($this) {
			self::Pending 			=> __('Pending'),
			self::Rejected 			=> __('Rejected'),
			self::Approved			=> __('Approved'),
			self::ViolatesPolicy	=> __('Violates our policy'),
		};
	}

	/**
	 * Find the enum case by key.
	 *
	 * @param  string  $key
	 * 
	 * @return self|null
	 */
	public static function fromKey (string $key) : ?self
	{
		return self::tryFrom($key);
	}

}
