<?php

namespace JLGR\Reviews\Actions;

use Illuminate\Support\Facades\Auth;
use JLGR\Reviews\Contracts\ReportsReview;
use JLGR\Reviews\Models\Review;
use JLGR\Reviews\Models\ReviewReport;

class ReportReview implements ReportsReview
{

	/**
	 * Report review.
	 *
	 * @param  integer  $reviewId
	 * 
	 * @return void
	 */
	public function handle (int $reviewId) : void
	{
		$review = Review::find($reviewId);

		if (!$review || $review->user_id === Auth::id()) {
			return;
		}

		ReviewReport::firstOrCreate([
			'review_id' => $reviewId,
			'user_id' => Auth::id(),
		]);
	}

}
