<div class="py-6">
	<div class="flex">
		
		{{-- AVATAR --}}
		<div class="mr-4 shrink-0">
			@include('reviews::partials.user-avatar', [ 'user' => $review->user ])
		</div>

		{{-- META --}}
		<div class="flex-1 pt-1">

			<h4 class="text-sm text-gray-800">
				{!!
					__('<span class="font-semibold">:user</span> rated :entity an average of <span class="font-semibold">:score</span> stars', [
						'user' => $review->user->name,
						'entity' => $review->reviewable?->name ?? 'this organisation',
						'score' => $review->average_rating
					])
				!!}
			</h4>

			<div class="flex gap-2 divide-x mt-1">

				{{-- META INFO: CREATION DATE --}}
				<span class="text-xs font-medium text-gray-500">
					{{ $review->created_at->diffForHumans() }}
				</span>

				{{-- REPORT REVIEW BUTTON --}}
				@include('reviews::livewire.reviews-list.partials.report-review-button')

			</div>
		</div>

	</div>

	{{-- REVIEW TEXT --}}
	<div class="mt-4">
		<div>
			<p class="text-sm text-slate-700 whitespace-pre-line">
				{!! nl2br(e($review->text)) !!}
			</p>
		</div>
	</div>

	{{-- REVIEW INDICATOR RATINGS --}}
	<div class="mt-4 space-y-2">
		@foreach ($review->ratings as $rating)
			@include('reviews::livewire.reviews-list.partials.indicator-rating', [
				'rating' => $rating
			])
		@endforeach
	</div>

</div>
