<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up ()
    {
        Schema::create('review_indicators', function (Blueprint $table) {
            $table->id();
            $table->string('reviewable_type'); 		// I.e.: AviatorsEcho\Models\Entities\FlightSchool
            $table->string('key');            		// I.e.: 'price'
            $table->string('label');           		// I.e.: 'Price/quality'
			$table->text('description')->nullable();
			$table->integer('order')->nullable();
            $table->unsignedInteger('weight')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down ()
    {
        Schema::dropIfExists('review_indicators');
    }

};
