<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up ()
    {
        Schema::create('reviews', function (Blueprint $table) {
            $table->id();
			$table->enum('status', [
				'pending',
				'approved',
				'rejected',
				'violates-policy',
			])->default('pending');
            $table->morphs('reviewable');
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); 
            $table->text('text')->nullable();
			$table->float('average_rating')->nullable();
			$table->timestamp('approved_at')->nullable()->index();
			$table->boolean('manually_approved')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down ()
    {
        Schema::dropIfExists('reviews');
    }

};
